import { Animated } from "react-native";
import dpr from "../../../screens/Utilities/CustomStyleAttribute/dpr";

export const modalHeight = dpr("hf") / 1.5;

export const openModal = (setIsVisible, modalY) => {
    setIsVisible(true);
    Animated.timing(modalY, {
        duration: 300,
        toValue: 0,
        useNativeDriver: true,
    }).start();
};

export const closeModal = (setIsVisible, modalY) => {
    setTimeout(() => {
        setIsVisible(false);
    }, 320);
    Animated.timing(modalY, {
        duration: 300,
        toValue: modalHeight,
        useNativeDriver: true,
    }).start();
};
